#include <esp_log.h>
#include <esp_system.h>
#include <nvs_flash.h>
#include <sys/param.h>
#include <string.h>

#include "freertos/FreeRTOS.h"
#include "freertos/task.h"

#include "esp_camera.h"

#include "camera_pinout.h"

#include <unistd.h>

static camera_config_t camera_config = {
  .pin_pwdn = CAM_PIN_PWDN,
  .pin_reset = CAM_PIN_RESET,
  .pin_xclk = CAM_PIN_XCLK,
  .pin_sccb_sda = CAM_PIN_SIOD,
  .pin_sccb_scl = CAM_PIN_SIOC,

  .pin_d7 = CAM_PIN_D7,
  .pin_d6 = CAM_PIN_D6,
  .pin_d5 = CAM_PIN_D5,
  .pin_d4 = CAM_PIN_D4,
  .pin_d3 = CAM_PIN_D3,
  .pin_d2 = CAM_PIN_D2,
  .pin_d1 = CAM_PIN_D1,
  .pin_d0 = CAM_PIN_D0,
  .pin_vsync = CAM_PIN_VSYNC,
  .pin_href = CAM_PIN_HREF,
  .pin_pclk = CAM_PIN_PCLK,

  //XCLK 20MHz or 10MHz for OV2640 double FPS (Experimental)
  .xclk_freq_hz = 20000000,
  .ledc_timer = LEDC_TIMER_0,
  .ledc_channel = LEDC_CHANNEL_0,

  .pixel_format = PIXFORMAT_JPEG, //YUV422,GRAYSCALE,RGB565,JPEG
  .frame_size = FRAMESIZE_QVGA, //FRAMESIZE_QVGA,    //QQVGA-UXGA, For ESP32, do not use sizes above QVGA when not JPEG. The performance of the ESP32-S series has improved a lot, but JPEG mode always gives better frame rates.

  .jpeg_quality = 60, //0-63, for OV series camera sensors, lower number means higher quality
  .fb_count = 4,       //When jpeg mode is used, if fb_count more than one, the driver will work in continuous mode. // 2 because claude said so :(
  .fb_location = CAMERA_FB_IN_PSRAM,
  // .fb_location = CAMERA_FB_IN_DRAM,
  .grab_mode = CAMERA_GRAB_LATEST, //CAMERA_GRAB_WHEN_EMPTY,
  //
  .sccb_i2c_port= 0,
};

typedef struct 
{
  uint32_t magic;
  uint16_t picsize;
} __attribute__((packed)) PictureHeader_t;

typedef struct 
{
  uint32_t magic;
} __attribute__((packed)) PictureFooter_t;

void writeToSerial(camera_fb_t *pic)
{
  uint16_t remaining = pic->len;
  uint16_t chunkSize = 128;
  uint32_t idx = 0;

  bool valid_start = (pic->buf[0] == 0xff && pic->buf[1] == 0xd8);
  bool valid_end = (pic->buf[pic->len-2] == 0xff && pic->buf[pic->len-1] == 0xd9);

  printf("\n=== IMAGE INFO ===\n");
  printf("Length: %d bytes\n", pic->len);
  printf("Width: %d\n", pic->width);
  printf("Height: %d\n", pic->height);
  printf("Format: %d\n", pic->format);
  printf("Valid start %d valid end %d\n", valid_start, valid_end);

  write(STDOUT_FILENO, "ASDF", 4);
  while (remaining > 0)
  {
    uint16_t toWrite = (remaining > chunkSize) ? chunkSize : remaining;
    write(STDOUT_FILENO, pic->buf + idx, toWrite);
    remaining -= toWrite;
    idx += toWrite;
  }
  // write(STDOUT_FILENO, pic->buf + pic->len, 10);
  write(STDOUT_FILENO, "QWER", 4);
  printf("Written %lu bytes\n", idx);
}

void app_main(void)
{
  printf("Hello world\n");
  int i = 0;
  esp_err_t err = esp_camera_init(&camera_config);
  bool success = (err == ESP_OK);

  // PictureHeader_t header = {.magic = 0x3131DEAD};
  PictureHeader_t header = {.magic = 0x3131DEAD};
  PictureFooter_t footer = {.magic = 0xaaaaaaaa};

  for (;;)
  {
    i++;

    if (success)
    {
      camera_fb_t *pic = esp_camera_fb_get();
      header.picsize = pic->len;
      // write(STDOUT_FILENO, &header, sizeof(PictureHeader_t));

      writeToSerial(pic);
      // write(STDOUT_FILENO, pic->buf, pic->len);
      // write(STDOUT_FILENO, &footer, sizeof(PictureFooter_t));
      esp_camera_fb_return(pic);
    }

    vTaskDelay(50 / portTICK_PERIOD_MS);
  }
}
