/*
  This example reads audio data from the on-board PDM microphones, and prints
  out the samples to the Serial console. The Serial Plotter built into the
  Arduino IDE can be used to plot the audio data (Tools -> Serial Plotter)

  Please try with the Circuit Playground Bluefruit

  This example code is in the public domain.
*/

#include <PDM.h>

#define BUFF_SIZE   512

// buffer to read samples into, each sample is 16-bits
short sampleBuffer[BUFF_SIZE];
short sampleData;

// number of samples read
volatile int samplesRead;

void setup() {
  Serial.begin(9600);
  while (!Serial) yield();

  //NRF_POWER->DCDCEN = 1;        // enable on chip DCDC converter
  //PDM.setPins(int dataPin, int clkPin, int pwrPin)

  // configure the data receive callback
  PDM.onReceive(onPDMdata);
  PDM.setBufferSize(BUFF_SIZE);   // void setBufferSize(int bufferSize);
  

  

  // optionally set the gain, defaults to 20
  // PDM.setGain(30);

  // initialize PDM with:
  // - one channel (mono mode)
  // - a 16 kHz sample rate
  if (!PDM.begin(1, 16000)) {
    Serial.println("Failed to start PDM!");
    while (1) yield();
  }

  PDM.setGain(70);                 // 0:-20dB, 40:0dB, 80:+20dB
}

void loop() {
  // wait for samples to be read
  if (samplesRead) {
     //Serial.print("Samples Read :");
     //Serial.println(samplesRead);
    //print samples to the serial monitor or plotter
    for (int i = 0; i < samplesRead; i++) {
      //Serial.println(sampleBuffer[i]);
      sampleData = sampleData + sampleBuffer[i];
    }
    sampleData = sampleData / samplesRead;
    Serial.println(sampleData);
    // clear the read count
    samplesRead = 0;
  }
}

void onPDMdata() {
  // query the number of bytes available
  int bytesAvailable = PDM.available();

  // read into the sample buffer
  PDM.read(sampleBuffer, bytesAvailable);

  // 16-bit, 2 bytes per sample
  samplesRead = bytesAvailable / 2;
}

