/*******************************************************************************
 * Size: 15 px
 * Bpp: 1
 * Opts: --font SpaceMono-Regular.ttf --size 15 --bpp 1 --format lvgl --range 0x20-0x7F --output spacemono.c
 ******************************************************************************/


#include <lvgl.h>
/*-----------------
 *    BITMAPS
 *----------------*/

/*Store the image of the glyphs*/
static LV_ATTRIBUTE_LARGE_CONST const uint8_t glyph_bitmap[] = {
    /* U+0020 " " */
    0x0,

    /* U+0021 "!" */
    0x55, 0x55, 0x3c,

    /* U+0022 "\"" */
    0xde, 0xd4, 0xa0,

    /* U+0023 "#" */
    0x24, 0x4b, 0xf9, 0x22, 0x5f, 0xc9, 0x12,

    /* U+0024 "$" */
    0x11, 0xe9, 0x65, 0x78, 0x79, 0x75, 0x78, 0x40,

    /* U+0025 "%" */
    0x60, 0x90, 0x90, 0x91, 0x66, 0x18, 0x6e, 0x91,
    0x11, 0x11, 0xe,

    /* U+0026 "&" */
    0x78, 0xc0, 0x80, 0x84, 0xc4, 0x3f, 0xc4, 0x84,
    0x84, 0xc4, 0x7c,

    /* U+0027 "'" */
    0xf5,

    /* U+0028 "(" */
    0x1c, 0x84, 0x30, 0x82, 0x8, 0x20, 0x82, 0x8,
    0x20, 0xc1, 0x2, 0x7,

    /* U+0029 ")" */
    0xe0, 0x40, 0x83, 0x4, 0x10, 0x41, 0x4, 0x10,
    0x41, 0xc, 0x21, 0x38,

    /* U+002A "*" */
    0x10, 0xa9, 0xf1, 0xcf, 0xe7, 0x15, 0x8,

    /* U+002B "+" */
    0x10, 0x4f, 0xc4, 0x10, 0x40,

    /* U+002C "," */
    0xf7,

    /* U+002D "-" */
    0xf8,

    /* U+002E "." */
    0xf0,

    /* U+002F "/" */
    0x8, 0x42, 0x21, 0x8, 0xc4, 0x23, 0x10, 0x8c,
    0x42, 0x0,

    /* U+0030 "0" */
    0x38, 0x8a, 0xc, 0x19, 0xb3, 0x60, 0xc1, 0x82,
    0x88, 0xe0,

    /* U+0031 "1" */
    0x30, 0xe1, 0x46, 0x89, 0x2, 0x4, 0x8, 0x10,
    0x23, 0xf8,

    /* U+0032 "2" */
    0x38, 0x8a, 0xc, 0x10, 0x21, 0x9e, 0x60, 0x81,
    0x3, 0xf8,

    /* U+0033 "3" */
    0xfe, 0x4, 0x30, 0x81, 0xc0, 0xe0, 0xc1, 0x82,
    0x88, 0xe0,

    /* U+0034 "4" */
    0x1c, 0x1c, 0x34, 0x24, 0x64, 0x44, 0xc4, 0x84,
    0xff, 0x4, 0x4,

    /* U+0035 "5" */
    0xfd, 0x2, 0x5, 0xce, 0x58, 0x40, 0xc1, 0x83,
    0x89, 0xe0,

    /* U+0036 "6" */
    0x38, 0x8a, 0xc, 0xb, 0xd8, 0xe0, 0xc1, 0x82,
    0x88, 0xe0,

    /* U+0037 "7" */
    0xfe, 0x4, 0x18, 0x20, 0x83, 0x4, 0x10, 0x20,
    0x81, 0x0,

    /* U+0038 "8" */
    0x7d, 0x8e, 0xc, 0x1c, 0x6f, 0xb1, 0xc1, 0x83,
    0x8d, 0xf0,

    /* U+0039 "9" */
    0x38, 0x8a, 0xc, 0x18, 0x38, 0xde, 0x81, 0x83,
    0x89, 0xe0,

    /* U+003A ":" */
    0xf0, 0xf,

    /* U+003B ";" */
    0xf0, 0xf, 0x70,

    /* U+003C "<" */
    0x6, 0x7b, 0xc4, 0xe, 0x7, 0x81, 0x80,

    /* U+003D "=" */
    0xfc, 0xf, 0xc0,

    /* U+003E ">" */
    0x81, 0xf0, 0x78, 0x11, 0xff, 0x20, 0x0,

    /* U+003F "?" */
    0x3c, 0x8e, 0xc, 0x10, 0x23, 0x84, 0x8, 0x0,
    0x60, 0xc0,

    /* U+0040 "@" */
    0x7e, 0x3, 0x79, 0xc9, 0x89, 0x89, 0x89, 0xc9,
    0x7f,

    /* U+0041 "A" */
    0x1c, 0xa, 0x5, 0x86, 0xc2, 0x21, 0x10, 0x8c,
    0xfe, 0x41, 0x20, 0xf0, 0x60,

    /* U+0042 "B" */
    0xfc, 0x8d, 0xa, 0x14, 0x6f, 0x11, 0xa1, 0x42,
    0x8f, 0xf0,

    /* U+0043 "C" */
    0x38, 0x8a, 0xc, 0x18, 0x10, 0x20, 0x41, 0x82,
    0x88, 0xe0,

    /* U+0044 "D" */
    0xfc, 0x89, 0xa, 0x14, 0x28, 0x50, 0xa1, 0x42,
    0x8f, 0xf0,

    /* U+0045 "E" */
    0xfe, 0x8, 0x20, 0x83, 0xf8, 0x20, 0x82, 0xf,
    0xc0,

    /* U+0046 "F" */
    0xfe, 0x8, 0x20, 0x83, 0xf8, 0x20, 0x82, 0x8,
    0x0,

    /* U+0047 "G" */
    0x38, 0x8a, 0xc, 0x18, 0x10, 0x2f, 0xc1, 0x82,
    0x8c, 0xe8,

    /* U+0048 "H" */
    0x83, 0x6, 0xc, 0x18, 0x3f, 0xe0, 0xc1, 0x83,
    0x6, 0x8,

    /* U+0049 "I" */
    0xfe, 0x20, 0x40, 0x81, 0x2, 0x4, 0x8, 0x10,
    0x23, 0xf8,

    /* U+004A "J" */
    0xe, 0x8, 0x10, 0x20, 0x40, 0x81, 0x42, 0x85,
    0x99, 0xe0,

    /* U+004B "K" */
    0x86, 0x8c, 0x88, 0x98, 0xb0, 0xe0, 0xb0, 0x98,
    0x88, 0x84, 0x86,

    /* U+004C "L" */
    0x81, 0x2, 0x4, 0x8, 0x10, 0x20, 0x40, 0x81,
    0x3, 0xf8,

    /* U+004D "M" */
    0xc3, 0xe7, 0xe7, 0xa5, 0xa5, 0xa5, 0xa5, 0xbd,
    0xbd, 0x99, 0x99,

    /* U+004E "N" */
    0xe3, 0xc6, 0x8d, 0x9b, 0x32, 0x66, 0xcd, 0x8b,
    0x1e, 0x38,

    /* U+004F "O" */
    0x38, 0x8a, 0xc, 0x18, 0x30, 0x60, 0xc1, 0x82,
    0x88, 0xe0,

    /* U+0050 "P" */
    0xfd, 0xe, 0xc, 0x18, 0x7f, 0xa0, 0x40, 0x81,
    0x2, 0x0,

    /* U+0051 "Q" */
    0x38, 0x8a, 0xc, 0x18, 0x30, 0x60, 0xc1, 0x82,
    0x88, 0xe0, 0x81, 0xc0,

    /* U+0052 "R" */
    0xfd, 0xe, 0xc, 0x18, 0x7f, 0xa1, 0x42, 0x85,
    0xa, 0x10,

    /* U+0053 "S" */
    0x3c, 0x63, 0x41, 0x41, 0x70, 0x1e, 0x3, 0x81,
    0x81, 0x43, 0x3e,

    /* U+0054 "T" */
    0xfe, 0x20, 0x40, 0x81, 0x2, 0x4, 0x8, 0x10,
    0x20, 0x40,

    /* U+0055 "U" */
    0x83, 0x6, 0xc, 0x18, 0x30, 0x60, 0xc1, 0x82,
    0x88, 0xe0,

    /* U+0056 "V" */
    0x41, 0xa0, 0x90, 0x4c, 0x62, 0x31, 0x10, 0xc8,
    0x6c, 0x14, 0xa, 0x7, 0x0,

    /* U+0057 "W" */
    0x9c, 0xca, 0x75, 0x2a, 0x95, 0x5a, 0xad, 0x54,
    0xaa, 0x57, 0x29, 0x9c, 0xc0,

    /* U+0058 "X" */
    0x42, 0x42, 0x24, 0x24, 0x18, 0x18, 0x18, 0x24,
    0x24, 0x42, 0x42,

    /* U+0059 "Y" */
    0x41, 0x31, 0x88, 0x84, 0x41, 0x40, 0xa0, 0x70,
    0x10, 0x8, 0x4, 0x2, 0x0,

    /* U+005A "Z" */
    0xfe, 0x4, 0x10, 0x60, 0x82, 0x8, 0x30, 0x41,
    0x3, 0xf8,

    /* U+005B "[" */
    0xea, 0xaa, 0xaa, 0xab,

    /* U+005C "\\" */
    0x84, 0x30, 0x84, 0x30, 0x84, 0x20, 0x84, 0x20,
    0x84, 0x20,

    /* U+005D "]" */
    0xd5, 0x55, 0x55, 0x57,

    /* U+005E "^" */
    0x38, 0x51, 0xb2, 0x2c, 0x60,

    /* U+005F "_" */
    0xfe,

    /* U+0060 "`" */
    0x48,

    /* U+0061 "a" */
    0x3a, 0x46, 0x82, 0x82, 0x82, 0x82, 0x46, 0x3b,

    /* U+0062 "b" */
    0x81, 0x2, 0x5, 0xcc, 0x50, 0x60, 0xc1, 0x83,
    0x8a, 0xe0,

    /* U+0063 "c" */
    0x3c, 0x8e, 0xc, 0x8, 0x10, 0x51, 0x9e,

    /* U+0064 "d" */
    0x2, 0x4, 0x9, 0xd4, 0x70, 0x60, 0xc1, 0x82,
    0x8c, 0xe8,

    /* U+0065 "e" */
    0x38, 0x8a, 0xf, 0xf8, 0x10, 0x51, 0x1e,

    /* U+0066 "f" */
    0x3e, 0x40, 0x87, 0xf2, 0x4, 0x8, 0x10, 0x20,
    0x40, 0x80,

    /* U+0067 "g" */
    0x3a, 0x8e, 0xc, 0x18, 0x30, 0x51, 0x9d, 0x2,
    0x5, 0xf8,

    /* U+0068 "h" */
    0x82, 0x8, 0x2e, 0xce, 0x18, 0x61, 0x86, 0x18,
    0x40,

    /* U+0069 "i" */
    0x30, 0xc0, 0x3c, 0x10, 0x41, 0x4, 0x10, 0x4f,
    0xc0,

    /* U+006A "j" */
    0x18, 0xc1, 0xf0, 0x84, 0x21, 0x8, 0x42, 0x10,
    0xfc,

    /* U+006B "k" */
    0x82, 0x8, 0x22, 0x9a, 0xca, 0x38, 0xa2, 0x48,
    0x80,

    /* U+006C "l" */
    0xf0, 0x20, 0x40, 0x81, 0x2, 0x4, 0x8, 0x10,
    0x23, 0xf8,

    /* U+006D "m" */
    0xef, 0x26, 0x4c, 0x99, 0x32, 0x64, 0xc9,

    /* U+006E "n" */
    0xbb, 0x38, 0x61, 0x86, 0x18, 0x61,

    /* U+006F "o" */
    0x38, 0x8a, 0xc, 0x18, 0x30, 0x51, 0x1c,

    /* U+0070 "p" */
    0xb9, 0x8a, 0xc, 0x18, 0x30, 0x71, 0x5c, 0x81,
    0x2, 0x0,

    /* U+0071 "q" */
    0x3a, 0x8e, 0xc, 0x18, 0x30, 0x51, 0x9d, 0x2,
    0x4, 0x8,

    /* U+0072 "r" */
    0xec, 0x64, 0x89, 0x2, 0x4, 0x8, 0x7c,

    /* U+0073 "s" */
    0x7a, 0x38, 0x3c, 0x1e, 0x18, 0x5e,

    /* U+0074 "t" */
    0x20, 0x82, 0x3f, 0x20, 0x82, 0x8, 0x20, 0x83,
    0xc0,

    /* U+0075 "u" */
    0x86, 0x18, 0x61, 0x86, 0x1c, 0xdd,

    /* U+0076 "v" */
    0x83, 0x8d, 0x1a, 0x26, 0xc5, 0x8a, 0x1c,

    /* U+0077 "w" */
    0xdc, 0xea, 0xd5, 0x6a, 0xa5, 0x52, 0xa9, 0x54,
    0xe6,

    /* U+0078 "x" */
    0x85, 0x24, 0x8c, 0x31, 0xe4, 0xa1,

    /* U+0079 "y" */
    0x86, 0x18, 0x61, 0x86, 0x1c, 0xdd, 0x4, 0x17,
    0xc0,

    /* U+007A "z" */
    0xfc, 0x10, 0x84, 0x21, 0x8, 0x3f,

    /* U+007B "{" */
    0x69, 0x24, 0x92, 0x89, 0x24, 0x93,

    /* U+007C "|" */
    0xff, 0xff,

    /* U+007D "}" */
    0xc4, 0x44, 0x44, 0x44, 0x34, 0x44, 0x44, 0x4c,

    /* U+007E "~" */
    0x32, 0xaa, 0x60
};


/*---------------------
 *  GLYPH DESCRIPTION
 *--------------------*/

static const lv_font_fmt_txt_glyph_dsc_t glyph_dsc[] = {
    {.bitmap_index = 0, .adv_w = 0, .box_w = 0, .box_h = 0, .ofs_x = 0, .ofs_y = 0} /* id = 0 reserved */,
    {.bitmap_index = 0, .adv_w = 147, .box_w = 1, .box_h = 1, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1, .adv_w = 147, .box_w = 2, .box_h = 11, .ofs_x = 4, .ofs_y = 0},
    {.bitmap_index = 4, .adv_w = 147, .box_w = 5, .box_h = 4, .ofs_x = 2, .ofs_y = 7},
    {.bitmap_index = 7, .adv_w = 147, .box_w = 7, .box_h = 8, .ofs_x = 1, .ofs_y = 2},
    {.bitmap_index = 14, .adv_w = 147, .box_w = 6, .box_h = 10, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 22, .adv_w = 147, .box_w = 8, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 33, .adv_w = 147, .box_w = 8, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 44, .adv_w = 147, .box_w = 2, .box_h = 4, .ofs_x = 4, .ofs_y = 7},
    {.bitmap_index = 45, .adv_w = 147, .box_w = 6, .box_h = 16, .ofs_x = 2, .ofs_y = -2},
    {.bitmap_index = 57, .adv_w = 147, .box_w = 6, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 69, .adv_w = 147, .box_w = 7, .box_h = 8, .ofs_x = 1, .ofs_y = 2},
    {.bitmap_index = 76, .adv_w = 147, .box_w = 6, .box_h = 6, .ofs_x = 1, .ofs_y = 2},
    {.bitmap_index = 81, .adv_w = 147, .box_w = 2, .box_h = 4, .ofs_x = 4, .ofs_y = -2},
    {.bitmap_index = 82, .adv_w = 147, .box_w = 5, .box_h = 1, .ofs_x = 2, .ofs_y = 4},
    {.bitmap_index = 83, .adv_w = 147, .box_w = 2, .box_h = 2, .ofs_x = 4, .ofs_y = 0},
    {.bitmap_index = 84, .adv_w = 147, .box_w = 5, .box_h = 15, .ofs_x = 2, .ofs_y = -2},
    {.bitmap_index = 94, .adv_w = 147, .box_w = 7, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 104, .adv_w = 147, .box_w = 7, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 114, .adv_w = 147, .box_w = 7, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 124, .adv_w = 147, .box_w = 7, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 134, .adv_w = 147, .box_w = 8, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 145, .adv_w = 147, .box_w = 7, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 155, .adv_w = 147, .box_w = 7, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 165, .adv_w = 147, .box_w = 7, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 175, .adv_w = 147, .box_w = 7, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 185, .adv_w = 147, .box_w = 7, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 195, .adv_w = 147, .box_w = 2, .box_h = 8, .ofs_x = 4, .ofs_y = 0},
    {.bitmap_index = 197, .adv_w = 147, .box_w = 2, .box_h = 10, .ofs_x = 4, .ofs_y = -2},
    {.bitmap_index = 200, .adv_w = 147, .box_w = 7, .box_h = 7, .ofs_x = 1, .ofs_y = 2},
    {.bitmap_index = 207, .adv_w = 147, .box_w = 6, .box_h = 3, .ofs_x = 1, .ofs_y = 4},
    {.bitmap_index = 210, .adv_w = 147, .box_w = 7, .box_h = 7, .ofs_x = 1, .ofs_y = 2},
    {.bitmap_index = 217, .adv_w = 147, .box_w = 7, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 227, .adv_w = 147, .box_w = 8, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 236, .adv_w = 147, .box_w = 9, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 249, .adv_w = 147, .box_w = 7, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 259, .adv_w = 147, .box_w = 7, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 269, .adv_w = 147, .box_w = 7, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 279, .adv_w = 147, .box_w = 6, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 288, .adv_w = 147, .box_w = 6, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 297, .adv_w = 147, .box_w = 7, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 307, .adv_w = 147, .box_w = 7, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 317, .adv_w = 147, .box_w = 7, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 327, .adv_w = 147, .box_w = 7, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 337, .adv_w = 147, .box_w = 8, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 348, .adv_w = 147, .box_w = 7, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 358, .adv_w = 147, .box_w = 8, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 369, .adv_w = 147, .box_w = 7, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 379, .adv_w = 147, .box_w = 7, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 389, .adv_w = 147, .box_w = 7, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 399, .adv_w = 147, .box_w = 7, .box_h = 13, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 411, .adv_w = 147, .box_w = 7, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 421, .adv_w = 147, .box_w = 8, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 432, .adv_w = 147, .box_w = 7, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 442, .adv_w = 147, .box_w = 7, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 452, .adv_w = 147, .box_w = 9, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 465, .adv_w = 147, .box_w = 9, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 478, .adv_w = 147, .box_w = 8, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 489, .adv_w = 147, .box_w = 9, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 502, .adv_w = 147, .box_w = 7, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 512, .adv_w = 147, .box_w = 2, .box_h = 16, .ofs_x = 4, .ofs_y = -2},
    {.bitmap_index = 516, .adv_w = 147, .box_w = 5, .box_h = 15, .ofs_x = 2, .ofs_y = -2},
    {.bitmap_index = 526, .adv_w = 147, .box_w = 2, .box_h = 16, .ofs_x = 3, .ofs_y = -2},
    {.bitmap_index = 530, .adv_w = 147, .box_w = 7, .box_h = 5, .ofs_x = 1, .ofs_y = 6},
    {.bitmap_index = 535, .adv_w = 147, .box_w = 7, .box_h = 1, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 536, .adv_w = 147, .box_w = 3, .box_h = 2, .ofs_x = 3, .ofs_y = 9},
    {.bitmap_index = 537, .adv_w = 147, .box_w = 8, .box_h = 8, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 545, .adv_w = 147, .box_w = 7, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 555, .adv_w = 147, .box_w = 7, .box_h = 8, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 562, .adv_w = 147, .box_w = 7, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 572, .adv_w = 147, .box_w = 7, .box_h = 8, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 579, .adv_w = 147, .box_w = 7, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 589, .adv_w = 147, .box_w = 7, .box_h = 11, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 599, .adv_w = 147, .box_w = 6, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 608, .adv_w = 147, .box_w = 6, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 617, .adv_w = 147, .box_w = 5, .box_h = 14, .ofs_x = 2, .ofs_y = -3},
    {.bitmap_index = 626, .adv_w = 147, .box_w = 6, .box_h = 11, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 635, .adv_w = 147, .box_w = 7, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 645, .adv_w = 147, .box_w = 7, .box_h = 8, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 652, .adv_w = 147, .box_w = 6, .box_h = 8, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 658, .adv_w = 147, .box_w = 7, .box_h = 8, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 665, .adv_w = 147, .box_w = 7, .box_h = 11, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 675, .adv_w = 147, .box_w = 7, .box_h = 11, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 685, .adv_w = 147, .box_w = 7, .box_h = 8, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 692, .adv_w = 147, .box_w = 6, .box_h = 8, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 698, .adv_w = 147, .box_w = 6, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 707, .adv_w = 147, .box_w = 6, .box_h = 8, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 713, .adv_w = 147, .box_w = 7, .box_h = 8, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 720, .adv_w = 147, .box_w = 9, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 729, .adv_w = 147, .box_w = 6, .box_h = 8, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 735, .adv_w = 147, .box_w = 6, .box_h = 11, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 744, .adv_w = 147, .box_w = 6, .box_h = 8, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 750, .adv_w = 147, .box_w = 3, .box_h = 16, .ofs_x = 3, .ofs_y = -2},
    {.bitmap_index = 756, .adv_w = 147, .box_w = 1, .box_h = 16, .ofs_x = 4, .ofs_y = -2},
    {.bitmap_index = 758, .adv_w = 147, .box_w = 4, .box_h = 16, .ofs_x = 3, .ofs_y = -2},
    {.bitmap_index = 766, .adv_w = 147, .box_w = 7, .box_h = 3, .ofs_x = 1, .ofs_y = 4}
};

/*---------------------
 *  CHARACTER MAPPING
 *--------------------*/



/*Collect the unicode lists and glyph_id offsets*/
static const lv_font_fmt_txt_cmap_t cmaps[] =
{
    {
        .range_start = 32, .range_length = 95, .glyph_id_start = 1,
        .unicode_list = NULL, .glyph_id_ofs_list = NULL, .list_length = 0, .type = LV_FONT_FMT_TXT_CMAP_FORMAT0_TINY
    }
};



/*--------------------
 *  ALL CUSTOM DATA
 *--------------------*/

#if LVGL_VERSION_MAJOR == 8
/*Store all the custom data of the font*/
static  lv_font_fmt_txt_glyph_cache_t cache;
#endif

#if LVGL_VERSION_MAJOR >= 8
static const lv_font_fmt_txt_dsc_t font_dsc = {
#else
static lv_font_fmt_txt_dsc_t font_dsc = {
#endif
    .glyph_bitmap = glyph_bitmap,
    .glyph_dsc = glyph_dsc,
    .cmaps = cmaps,
    .kern_dsc = NULL,
    .kern_scale = 0,
    .cmap_num = 1,
    .bpp = 1,
    .kern_classes = 0,
    .bitmap_format = 0,
#if LVGL_VERSION_MAJOR == 8
    .cache = &cache
#endif
};



/*-----------------
 *  PUBLIC FONT
 *----------------*/

/*Initialize a public general font descriptor*/
#if LVGL_VERSION_MAJOR >= 8
const lv_font_t spacemono = {
#else
lv_font_t spacemono = {
#endif
    .get_glyph_dsc = lv_font_get_glyph_dsc_fmt_txt,    /*Function pointer to get glyph's data*/
    .get_glyph_bitmap = lv_font_get_bitmap_fmt_txt,    /*Function pointer to get glyph's bitmap*/
    .line_height = 17,          /*The maximum line height required by the font*/
    .base_line = 3,             /*Baseline measured from the bottom of the line*/
#if !(LVGL_VERSION_MAJOR == 6 && LVGL_VERSION_MINOR == 0)
    .subpx = LV_FONT_SUBPX_NONE,
#endif
#if LV_VERSION_CHECK(7, 4, 0) || LVGL_VERSION_MAJOR >= 8
    .underline_position = -1,
    .underline_thickness = 1,
#endif
    .dsc = &font_dsc,          /*The custom font data. Will be accessed by `get_glyph_bitmap/dsc` */
#if LV_VERSION_CHECK(8, 2, 0) || LVGL_VERSION_MAJOR >= 9
    .fallback = NULL,
#endif
    .user_data = NULL,
};


